﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Web_Files_Enhanced.Properties;

namespace Web_Files_Enhanced
{
    public partial class SettingsForm : Form
    {
        private MainForm _frmMain;

        public SettingsForm(MainForm frmMain)
        {
            _frmMain = frmMain;
            InitializeComponent();
            SetFontDisplayLabel();
            chkHorizSplitView.Checked = Settings.Default.SplitViewOrient == Orientation.Horizontal;
        }

        private void SetFontDisplayLabel()
        {
            FontFamily family = Settings.Default.EditorFont.FontFamily;
            lblFontDisplay.Font = new Font(family, 14f, Settings.Default.EditorFont.Style);
        }

        private void btnPickFont_Click(object sender, EventArgs e)
        {
            try
            {
                using (FontDialog dlgFont = new FontDialog())
                {
                    dlgFont.ShowEffects = false;
                    dlgFont.AllowScriptChange = false;

                    if (dlgFont.ShowDialog() == DialogResult.OK)
                    {

                        Settings.Default.EditorFont = dlgFont.Font;
                        SetFontDisplayLabel();
                        _frmMain.TextEditor.Font = dlgFont.Font;
                    }
                }
            }
            catch (ArgumentException ex) 
            {
                MessageBox.Show(ex.Message, Application.ProductName, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void chkHorizSplitView_CheckedChanged(object sender, EventArgs e)
        {
            Orientation temp = chkHorizSplitView.Checked ? Orientation.Horizontal : Orientation.Vertical;
            Settings.Default.SplitViewOrient = temp;
            _frmMain.SplitView.Orientation = temp;

            // Set the splitter half way
            if (chkHorizSplitView.Checked)
            {
                _frmMain.SplitView.SplitterDistance = _frmMain.SplitView.ClientSize.Height / 2;
            }
            else
            {
                _frmMain.SplitView.SplitterDistance = _frmMain.SplitView.ClientSize.Width / 2;
            }
        }
    }
}
